/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio;

import android.smartcardio.CardException;
import android.smartcardio.CardTerminal;
import android.smartcardio.CardTerminals;
import android.smartcardio.TerminalFactorySpi;
import android.smartcardio.ipc.IBackendIPC;
import android.smartcardio.ipc.ITheobromaJNI;
import android.smartcardio.ipc.TheobromaJNI;
import android.smartcardio.theobroma.TheobromaTerminalFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TerminalFactory {
    private ITheobromaJNI theobromaJni;
    public static final String PCSC_TYPE = "PC/SC";
    public static final String NATIVE_TYPE = "Native";
    public static final String NONE_TYPE = "None";
    private static final Map<String, TerminalFactory> factories = new HashMap<String, TerminalFactory>();
    private static final String DEFAULT_TYPE;
    private final TerminalFactorySpi spi;
    private final Provider provider;
    private final String type;

    static {
        factories.put(NONE_TYPE, new TerminalFactory(new NoneTerminalFactory(), new NoneProvider(), NONE_TYPE));
        String type = NONE_TYPE;
        try {
            TerminalFactory theobromaFactory = TerminalFactory.createFactory(PCSC_TYPE, "android.smartcardio.theobroma.TheobromaTerminalFactory", "android.smartcardio.theobroma.TheobromaProvider");
            factories.put(PCSC_TYPE, theobromaFactory);
            type = PCSC_TYPE;
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_TYPE = type;
    }

    private static TerminalFactory createFactory(String type, String spiClassName, String providerClassName) throws NoSuchAlgorithmException {
        try {
            Class<?> clazz = Class.forName(spiClassName);
            TerminalFactorySpi spi = (TerminalFactorySpi)clazz.newInstance();
            clazz = Class.forName(providerClassName);
            Provider provider = (Provider)clazz.newInstance();
            return new TerminalFactory(spi, provider, type);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException(e);
        }
    }

    public static TerminalFactory getDefault() {
        try {
            return TerminalFactory.getInstance(DEFAULT_TYPE, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void setCardService(IBackendIPC cardService) {
        this.theobromaJni = TheobromaJNI.getInstance(cardService);
    }

    public static String getDefaultType() {
        return DEFAULT_TYPE;
    }

    public static TerminalFactory getInstance(String type, Object params) throws NoSuchAlgorithmException {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        TerminalFactory factory = factories.get(type);
        if (factory == null) {
            throw new NoSuchAlgorithmException("type: " + type + " not supported");
        }
        return factory;
    }

    public static TerminalFactory getInstance(String type, Object params, Provider provider) {
        throw new UnsupportedOperationException("work in progress");
    }

    public static TerminalFactory getInstance(String type, Object params, String provider) {
        throw new UnsupportedOperationException("work in progress");
    }

    private TerminalFactory(TerminalFactorySpi spi, Provider provider, String type) {
        this.spi = spi;
        this.provider = provider;
        this.type = type;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public CardTerminals terminals() {
        if (this.theobromaJni != null) {
            return ((TheobromaTerminalFactory)this.spi).engineTerminals(this.theobromaJni);
        }
        return this.spi.engineTerminals();
    }

    public String toString() {
        return "TerminalFactory:" + this.spi + ", type:" + this.type + ", provider:" + this.provider;
    }

    private static final class NoneCardTerminals
    extends CardTerminals {
        static final NoneCardTerminals STATIC_INSTANCE = new NoneCardTerminals();

        private NoneCardTerminals() {
        }

        @Override
        public List<CardTerminal> list(CardTerminals.State state) throws CardException {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean waitForChange(long timeout) throws CardException {
            throw new IllegalStateException("no card terminals");
        }
    }

    private static final class NoneProvider
    extends Provider {
        private static final long serialVersionUID = -6126436159055513301L;

        private NoneProvider() {
            super("NoneProvider", 0.9, "None terminal provider");
        }
    }

    private static final class NoneTerminalFactory
    extends TerminalFactorySpi {
        private NoneTerminalFactory() {
        }

        @Override
        protected CardTerminals engineTerminals() {
            return NoneCardTerminals.STATIC_INSTANCE;
        }
    }
}

