/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.ipc;

import android.os.RemoteException;
import android.smartcardio.ipc.IBackendIPC;
import android.smartcardio.ipc.ITheobromaJNI;

public class TheobromaJNI
implements ITheobromaJNI {
    private static ITheobromaJNI jni;
    private IBackendIPC service;

    public static ITheobromaJNI getInstance(IBackendIPC service) {
        if (jni == null) {
            jni = new TheobromaJNI(service);
        }
        return jni;
    }

    private TheobromaJNI(IBackendIPC service) {
        this.service = service;
    }

    @Override
    public long establishContext() throws RemoteException {
        return this.service.SCardEstablishContext();
    }

    @Override
    public String[] listReaders(long contextId) throws RemoteException {
        return this.service.SCardListReaders(contextId);
    }

    @Override
    public long connect(long contextId, String readerName, int shareMode) throws RemoteException {
        return this.service.SCardConnect(contextId, readerName, shareMode);
    }

    @Override
    public int disconnect(long cardId) throws RemoteException {
        return this.service.SCardDisconnect(cardId);
    }

    @Override
    public int[] waitForChange(long contextId, int timeout, int[] currentStates, int[] expectedStates, String[] readerNames) throws RemoteException {
        return this.service.SCardWaitForChange(contextId, timeout, readerNames, currentStates, expectedStates);
    }

    @Override
    public byte[] powerOn(long cardId) throws RemoteException {
        return this.service.SCardPowerOn(cardId);
    }

    @Override
    public int setProtocol(long cardId, int preferredProtocols) throws RemoteException {
        return this.service.SCardSetProtocol(cardId, preferredProtocols);
    }

    @Override
    public byte[] control(long cardId, int controlCode, byte[] sendBuffer) throws RemoteException {
        return this.service.SCardControl(cardId, controlCode, sendBuffer);
    }

    @Override
    public byte[] transmit(long cardId, int protocol, byte[] command) throws RemoteException {
        if (command == null) {
            return null;
        }
        return this.service.SCardTransmit(cardId, protocol, command, 0, command.length);
    }

    @Override
    public boolean beginTransaction(long cardId) throws RemoteException {
        return this.service.SCardBeginTransaction(cardId);
    }

    @Override
    public boolean endTransaction(long cardId) throws RemoteException {
        return this.service.SCardEndTransaction(cardId);
    }
}

