/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.theobroma;

import android.smartcardio.Card;
import android.smartcardio.CardChannel;
import android.smartcardio.CardException;
import android.smartcardio.CommandAPDU;
import android.smartcardio.ResponseAPDU;
import android.smartcardio.theobroma.TheobromaCard;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class TheobromaCardChannel
extends CardChannel {
    private static final String TAG = "TheobromaCardChannel";
    private final TheobromaCard card;
    private volatile boolean isOpen = true;
    private final int channelNumber;

    public TheobromaCardChannel(TheobromaCard card, int channelNumber) {
        this.card = card;
        this.channelNumber = channelNumber;
    }

    @Override
    public Card getCard() {
        return this.card;
    }

    @Override
    public int getChannelNumber() {
        this.assertChannelOpenAndCardConnected();
        return this.channelNumber;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU command) throws CardException {
        this.assertChannelOpenAndCardConnected();
        return new ResponseAPDU(this.internalTransmit(command.getBytes()));
    }

    @Override
    public int transmit(ByteBuffer command, ByteBuffer response) throws CardException {
        this.assertChannelOpenAndCardConnected();
        if (command == null || response == null) {
            throw new NullPointerException("command/response buffer must not be null");
        }
        if (response.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (command == response) {
            throw new IllegalArgumentException("command and response buffer must not be identical");
        }
        if (response.remaining() < 258) {
            throw new IllegalArgumentException("free space of response buffer must not be smaller than 258");
        }
        byte[] cmd = new byte[command.remaining()];
        command.get(cmd);
        byte[] rsp = this.internalTransmit(cmd);
        response.put(rsp);
        return rsp.length;
    }

    @Override
    public void close() throws CardException {
        if (!this.isOpen) {
            return;
        }
        if (this.channelNumber == 0) {
            throw new IllegalStateException("basic logical channel cannot be closed");
        }
        byte[] manageChannelClose = new byte[]{(byte)this.channelNumber, 112, -128, (byte)this.channelNumber};
        this.card.transmit(manageChannelClose, 2, 36864, 65535, "MANAGE CHANNEL");
        this.isOpen = false;
    }

    private byte[] internalTransmit(byte[] cmd) throws CardException {
        int logicalChannelNumber;
        if (cmd == null) {
            throw new NullPointerException();
        }
        if (cmd.length < 4) {
            throw new IllegalArgumentException("command must not be smaller than 4 bytes");
        }
        if ((cmd[0] & 0x80) == 0 && (cmd[0] & 0x60) != 32 && (logicalChannelNumber = cmd[0] & 3) == 0) {
            int cla = cmd[0] & 0x7F;
            cla = this.channelNumber < 4 ? cla & 0x1C | this.channelNumber : cla & 0x30 | 0x40 | this.channelNumber;
            cmd[0] = (byte)cla;
        }
        byte[] rsp = this.card.transmit(cmd, 2, 0, 0);
        return rsp;
    }

    private void assertChannelOpenAndCardConnected() {
        if (!this.isOpen) {
            throw new IllegalStateException("channel is closed");
        }
        if (!this.card.isConnected()) {
            throw new IllegalStateException("card is disconnected");
        }
    }
}

