/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.ipc;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBackendIPC
extends IInterface {
    public long SCardEstablishContext() throws RemoteException;

    public String[] SCardListReaders(long var1) throws RemoteException;

    public long SCardConnect(long var1, String var3, int var4) throws RemoteException;

    public byte[] SCardPowerOn(long var1) throws RemoteException;

    public int SCardSetProtocol(long var1, int var3) throws RemoteException;

    public int SCardDisconnect(long var1) throws RemoteException;

    public byte[] SCardControl(long var1, int var3, byte[] var4) throws RemoteException;

    public byte[] SCardTransmit(long var1, int var3, byte[] var4, int var5, int var6) throws RemoteException;

    public int[] SCardWaitForChange(long var1, int var3, String[] var4, int[] var5, int[] var6) throws RemoteException;

    public boolean SCardBeginTransaction(long var1) throws RemoteException;

    public boolean SCardEndTransaction(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackendIPC {
        private static final String DESCRIPTOR = "android.smartcardio.ipc.IBackendIPC";
        static final int TRANSACTION_SCardEstablishContext = 1;
        static final int TRANSACTION_SCardListReaders = 2;
        static final int TRANSACTION_SCardConnect = 3;
        static final int TRANSACTION_SCardPowerOn = 4;
        static final int TRANSACTION_SCardSetProtocol = 5;
        static final int TRANSACTION_SCardDisconnect = 6;
        static final int TRANSACTION_SCardControl = 7;
        static final int TRANSACTION_SCardTransmit = 8;
        static final int TRANSACTION_SCardWaitForChange = 9;
        static final int TRANSACTION_SCardBeginTransaction = 10;
        static final int TRANSACTION_SCardEndTransaction = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBackendIPC asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBackendIPC) {
                return (IBackendIPC)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    long _result = this.SCardEstablishContext();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    String[] _result = this.SCardListReaders(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    long _result = this.SCardConnect(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    byte[] _result = this.SCardPowerOn(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _result = this.SCardSetProtocol(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    int _result = this.SCardDisconnect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    byte[] _result = this.SCardControl(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _result = this.SCardTransmit(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    String[] _arg2 = data.createStringArray();
                    int[] _arg3 = data.createIntArray();
                    int[] _arg4 = data.createIntArray();
                    int[] _result = this.SCardWaitForChange(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    boolean _result = this.SCardBeginTransaction(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    boolean _result = this.SCardEndTransaction(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IBackendIPC {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public long SCardEstablishContext() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public String[] SCardListReaders(long contextId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(contextId);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public long SCardConnect(long contextId, String readerName, int shareMode) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(contextId);
                    _data.writeString(readerName);
                    _data.writeInt(shareMode);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public byte[] SCardPowerOn(long cardId) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public int SCardSetProtocol(long cardId, int preferredProtocols) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    _data.writeInt(preferredProtocols);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public int SCardDisconnect(long cardId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public byte[] SCardControl(long cardId, int controlCode, byte[] command) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    _data.writeInt(controlCode);
                    _data.writeByteArray(command);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public byte[] SCardTransmit(long cardId, int protocol, byte[] command, int offset, int len) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    _data.writeInt(protocol);
                    _data.writeByteArray(command);
                    _data.writeInt(offset);
                    _data.writeInt(len);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public int[] SCardWaitForChange(long contextId, int timeout, String[] readerNames, int[] currentStates, int[] expectedStates) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(contextId);
                    _data.writeInt(timeout);
                    _data.writeStringArray(readerNames);
                    _data.writeIntArray(currentStates);
                    _data.writeIntArray(expectedStates);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public boolean SCardBeginTransaction(long cardId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public boolean SCardEndTransaction(long cardId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

