/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.theobroma;

import android.os.RemoteException;
import android.smartcardio.CardException;
import android.smartcardio.CardTerminal;
import android.smartcardio.CardTerminals;
import android.smartcardio.ipc.ITheobromaJNI;
import android.smartcardio.theobroma.TheobromaCardTerminal;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TheobromaCardTerminals
extends CardTerminals {
    private static final String TAG = "TheobromaCardTerminals";
    private ITheobromaJNI theobromaJni;
    private static long contextHandle = 0L;
    private static final Map<String, CardTerminal> terminals = new HashMap<String, CardTerminal>();
    private volatile Map<String, TerminalInfo> terminalInfoMap = new HashMap<String, TerminalInfo>();
    private volatile boolean isInitialized = false;

    public TheobromaCardTerminals() {
    }

    public TheobromaCardTerminals(ITheobromaJNI theobromaJni) {
        this.logDebug(TAG, "creating new instance, contextHandle = " + contextHandle);
        this.theobromaJni = theobromaJni;
        try {
            if (contextHandle == 0L) {
                contextHandle = theobromaJni.establishContext();
                this.logDebug(TAG, "new contextHandle " + contextHandle);
            }
        }
        catch (RemoteException e) {
            this.logError(TAG, e.toString());
        }
    }

    @Override
    public List<CardTerminal> list(CardTerminals.State state) throws CardException {
        String[] readerNames;
        if (state == null) {
            throw new NullPointerException();
        }
        CardTerminals.State listState = state;
        if (!this.isInitialized) {
            if (state == CardTerminals.State.CARD_INSERTION) {
                listState = CardTerminals.State.CARD_PRESENT;
            } else if (state == CardTerminals.State.CARD_REMOVAL) {
                listState = CardTerminals.State.CARD_ABSENT;
            }
        }
        if ((readerNames = this.internalListReaders()) == null) {
            throw new CardException("list: cannot get reader names");
        }
        ArrayList<CardTerminal> cardTerminalList = new ArrayList<CardTerminal>(readerNames.length);
        String[] stringArray = readerNames;
        int n = readerNames.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalInfo terminalInfo;
            String readerName = stringArray[n2];
            CardTerminal cardTerminal = this.internalGetTerminal(readerName);
            if (listState == CardTerminals.State.ALL) {
                cardTerminalList.add(cardTerminal);
            } else if (listState == CardTerminals.State.CARD_PRESENT || listState == CardTerminals.State.CARD_ABSENT) {
                boolean present = cardTerminal.isCardPresent();
                if (present && listState == CardTerminals.State.CARD_PRESENT) {
                    cardTerminalList.add(cardTerminal);
                } else if (!present && listState == CardTerminals.State.CARD_ABSENT) {
                    cardTerminalList.add(cardTerminal);
                }
            } else if ((listState == CardTerminals.State.CARD_INSERTION || listState == CardTerminals.State.CARD_REMOVAL) && (terminalInfo = this.terminalInfoMap.get(readerName)) != null && terminalInfo.getCardState() == listState) {
                cardTerminalList.add(cardTerminal);
            }
            ++n2;
        }
        return Collections.unmodifiableList(cardTerminalList);
    }

    @Override
    public boolean waitForChange(long timeout) throws CardException {
        Map<String, TerminalInfo> infoMap;
        if (timeout < 0L) {
            throw new IllegalArgumentException("waitForChange: timeout must not be negative");
        }
        String[] readerNames = this.internalListReaders();
        if (readerNames == null || readerNames.length == 0) {
            this.terminalInfoMap.clear();
            throw new IllegalStateException("waitForChange: no card terminals available");
        }
        if (!this.isInitialized) {
            infoMap = this.createTerminalInfoMap(readerNames);
            this.internalWaitForChange(1L, infoMap);
            this.terminalInfoMap = infoMap;
            this.isInitialized = true;
        }
        infoMap = this.createTerminalInfoMap(readerNames);
        boolean eventRaised = this.internalWaitForChange(timeout, infoMap);
        this.terminalInfoMap = infoMap;
        return eventRaised;
    }

    private String[] internalListReaders() {
        try {
            String[] readerNames = this.theobromaJni.listReaders(contextHandle);
            return readerNames;
        }
        catch (RemoteException e) {
            this.logError("internalListReaders", "failed to get list " + e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardTerminal internalGetTerminal(String name) {
        Class<TheobromaCardTerminals> clazz = TheobromaCardTerminals.class;
        synchronized (TheobromaCardTerminals.class) {
            CardTerminal terminal = terminals.get(name);
            if (terminal == null) {
                terminal = new TheobromaCardTerminal(contextHandle, name, this.theobromaJni);
                terminals.put(name, terminal);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return terminal;
        }
    }

    private boolean internalWaitForChange(long timeout, Map<String, TerminalInfo> infoMap) throws CardException {
        try {
            String[] readerNames = infoMap.keySet().toArray(new String[1]);
            int[] currentStates = new int[readerNames.length];
            int i = 0;
            while (i < readerNames.length) {
                TheobromaTerminalInfo info = (TheobromaTerminalInfo)infoMap.get(readerNames[i]);
                if (info == null) {
                    info = new TheobromaTerminalInfo();
                    infoMap.put(readerNames[i], info);
                }
                currentStates[i] = info.getReaderState();
                ++i;
            }
            int[] newStates = this.theobromaJni.waitForChange(contextHandle, (int)timeout, currentStates, null, readerNames);
            if (newStates == null) {
                throw new CardException("internalWaitForChange: cannot get reader status");
            }
            boolean eventRaised = false;
            int i2 = 0;
            while (i2 < readerNames.length) {
                TheobromaTerminalInfo info = (TheobromaTerminalInfo)infoMap.get(readerNames[i2]);
                if (currentStates[i2] != newStates[i2]) {
                    eventRaised = true;
                    info.updateReaderState(newStates[i2]);
                }
                ++i2;
            }
            return eventRaised;
        }
        catch (RemoteException e) {
            throw new CardException("internalWaitForChange", e);
        }
    }

    private Map<String, TerminalInfo> createTerminalInfoMap(String[] readerNames) {
        HashMap<String, TerminalInfo> infoMap = new HashMap<String, TerminalInfo>(readerNames.length);
        String[] stringArray = readerNames;
        int n = readerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String readerName = stringArray[n2];
            infoMap.put(readerName, this.terminalInfoMap.get(readerName));
            ++n2;
        }
        return infoMap;
    }

    private void logDebug(String function, String message) {
        Log.d((String)TAG, (String)("[" + Thread.currentThread().getId() + "] " + function + " " + message));
    }

    private void logError(String function, String message) {
        Log.e((String)TAG, (String)("[" + Thread.currentThread().getId() + "] " + function + " " + message));
    }

    static abstract class TerminalInfo {
        protected CardTerminals.State cardState = CardTerminals.State.CARD_ABSENT;

        TerminalInfo() {
        }

        CardTerminals.State getCardState() {
            return this.cardState;
        }
    }

    private static class TheobromaTerminalInfo
    extends TerminalInfo {
        private int readerState = 3;

        private TheobromaTerminalInfo() {
        }

        public int getReaderState() {
            return this.readerState;
        }

        public void updateReaderState(int state) {
            boolean isPresent;
            boolean wasPresent = this.readerState == 2;
            boolean bl = isPresent = state == 2;
            this.cardState = isPresent != wasPresent ? (isPresent ? CardTerminals.State.CARD_INSERTION : CardTerminals.State.CARD_REMOVAL) : (isPresent ? CardTerminals.State.CARD_PRESENT : CardTerminals.State.CARD_ABSENT);
            this.readerState = state;
        }
    }
}

